/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdripper.block.entity;

import dev.ftb.mods.ftbdripper.FTBDripper;
import dev.ftb.mods.ftbdripper.block.DripperBlock;
import dev.ftb.mods.ftbdripper.block.entity.FTBDripperBlockEntities;
import dev.ftb.mods.ftbdripper.recipe.DripRecipe;
import dev.ftb.mods.ftbdripper.recipe.FTBDripperRecipeSerializers;
import dev.ftb.mods.ftbdripper.recipe.NoInventory;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DripperBlockEntity
extends BlockEntity {
    public final FluidTank tank = new FluidTank(4000){

        protected void onContentsChanged() {
            DripperBlockEntity.this.fluidChanged();
        }
    };
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private int prevAmount = -1;
    private Fluid prevFluid = null;

    public DripperBlockEntity(BlockPos pos, BlockState state) {
        super(FTBDripperBlockEntities.DRIPPER.get(), pos, state);
    }

    public void writeData(CompoundTag tag) {
        tag.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void readData(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("Tank"));
    }

    protected void m_183515_(CompoundTag tag) {
        this.writeData(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readData(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.writeData(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.readData(packet.m_131708_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private void fluidChanged() {
        this.m_6596_();
        if (!this.f_58857_.m_5776_() && this.prevAmount != this.tank.getFluidAmount()) {
            this.prevAmount = this.tank.getFluidAmount();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DripperBlock.ACTIVE, (Comparable)Boolean.valueOf(this.prevAmount > 0)), 3);
        }
        if (!this.f_58857_.m_5776_() && this.prevFluid != this.tank.getFluid().getFluid()) {
            this.prevFluid = this.tank.getFluid().getFluid();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        }
    }

    public void tick(BlockState state, BlockPos posBelow, BlockState blockBelow, Random random) {
        if (!this.tank.isEmpty()) {
            FluidStack fluid = this.tank.drain(FTBDripper.consumedFluid, IFluidHandler.FluidAction.EXECUTE);
            for (DripRecipe recipe : this.f_58857_.m_7465_().m_44056_((RecipeType)FTBDripperRecipeSerializers.DRIP_TYPE.get(), (Container)NoInventory.INSTANCE, this.f_58857_)) {
                if (recipe.fluid != fluid.getFluid() || !recipe.testInput(blockBelow)) continue;
                if (!(random.nextDouble() < recipe.chance)) break;
                this.f_58857_.m_7731_(posBelow, recipe.output, 3);
                break;
            }
        }
    }
}

